/** @file   display.h
 * @brief   Declaration of Display - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:37 $
 * @author  Tomi Lamminsaari
 */


#ifndef H_ENG2D_DISPLAY_H
#define H_ENG2D_DISPLAY_H

#include "eng2d_dll.h"

// Forward declarations
struct BITMAP;


namespace eng2d {

/** @class  Display
 * @brief   Manages the screenmodes and background buffers.
 * @author  Tomi Lamminsaari
 *
 * This class encapsulates the screen management operations. Since
 * this supports only one screen, there is no need to create any
 * instances of this class. All the members are static.
 */
class DLLIMPORT Display
{
public:

  ///
  /// Static members and methods
  /// ==========================
  
  /** The possible update-methods.
   */
  enum Method {
    /** Normal double-buffered display. */
    DOUBLEBUFFER,
    /** Page flipping. NOT IMPLEMENTED! */
    PAGEFLIP
  };
  
  /** The pointer to the double buffer or hidden page (depending on
   * selected update-method).
   */
  static BITMAP* buffer;
  
  /** Sets up the screenmode. All the screenmodes are fullscreen-modes.
   * @param     width             The width of the requested screenmode.
   * @param     height            The height of the requested screenmode.
   * @param     depth             Colordepth in bits.
   * @param     m                 The update-method.
   * @return    0 if successful. A negative number if fails.
   */
  static int setUp(int width, int height, int depth, Method m);
  
  /** Sets up the doublebuffered screen.
   * @param     width             Width of the screenmode.
   * @param     height            Height of the screenmode.
   * @param     depth             Colordepth in bits.
   * @return    0 if successful. Negative number if fails.
   */
  static int setUpDB(int width, int height, int depth);
  
  
  /** Closes the screenmode. Returns to the windows-desktop.
   */
  static void textmode();
  
  /** Blits the double buffer to the screen or changes the visible page.
   */
  static void flip();
  
  /** Blits only part of the double buffer to the screen. This won't work
   * when using other updatemethod than doublebuffered.
   * @param     x                 TopLeft x.
   * @param     y                 TopLeft y.
   * @param     w                 Width of the area being flipped.
   * @param     h                 Height of the area being flipped.
   */
  static void flip(int x, int y, int w, int h);
  
  /** Returns the width of current screenmode.
   * @return    Width of the screenmode in pixels.
   */
  static int scrWidth();
  
  /** Returns the height of current screenmode
   * @return    Height of the screenmode in pixels.
   */
  static int scrHeight();

protected:

  ///
  /// Members
  /// =======
  
  /** Selected update method */
  static Method updateMethod;

};

};

#endif
